### 59.2.1. 自定义版本管理

如果你需要不同于Spring Boot的"blessed"依赖，有可能的话可以自定义`ResolutionStrategy`使用的版本。替代的版本元数据使用`versionManagement`配置。例如：
```gradle
dependencies {
    versionManagement("com.mycorp:mycorp-versions:1.0.0.RELEASE@properties")
    compile("org.springframework.data:spring-data-hadoop")
}
```
版本信息需要作为一个`.properties`文件发布到一个仓库中。对于上面的示例，`mycorp-versions.properties`文件可能包含以下内容：
```java
org.springframework.data\:spring-data-hadoop=2.0.0.RELEASE
```
属性文件优先于Spring Boot默认设置，如果有必要的话可以覆盖版本号。
